using System;
using System.Runtime.Serialization;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>03/04/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Exception class used to report problems with VBECS application configuration file. 
	/// </summary>
	#endregion

	[Serializable]
	public class VbecsConfigurationException : BaseApplicationException
	{
		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3876"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>New object.</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1757"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public VbecsConfigurationException() 
			: base() {}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3877"> 
		///		<ExpectedInput>string.</ExpectedInput>
		///		<ExpectedOutput>Exception with string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3878"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public VbecsConfigurationException( string message )
			: base( message ) {}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/5/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3879"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>New object.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="3880"> 
		///		<ExpectedInput>Valid test message.</ExpectedInput>
		///		<ExpectedOutput>Valid test message.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3881"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public VbecsConfigurationException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
